// $Id: runtimemain.m,v 1.1 2002/08/13 09:09:56 hns Exp $
//
//  main.m
//  CocoaBasic
//
//  Created by Dr. H. Nikolaus Schaller on Fri Jun 14 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <HNSAppKit/HNSTypedTensor.h>
#import <HNSAppKit/HNSCocoaScript.h>

int main(int argc, const char *argv[])
{
	NSAutoreleasePool *pool=[[NSAutoreleasePool alloc] init];
	NSArray *theplugins=[NSBundle pathsForResourcesOfType:@"bundle" inDirectory:[[NSBundle mainBundle] builtInPlugInsPath]];
	NSEnumerator* enumerator = [theplugins objectEnumerator];
	NSString* pluginPath;
#if 1
	NSLog(@"runtime main\n");
#endif
	pool=[[NSAutoreleasePool alloc] init];
	theplugins=[NSBundle pathsForResourcesOfType:@"bundle" inDirectory:[[NSBundle mainBundle] builtInPlugInsPath]];
	enumerator = [theplugins objectEnumerator];
	[NSApplication sharedApplication];	// initialize window server
#if 1
	NSLog(@"load plugins\n");
#endif
	while((pluginPath=[enumerator nextObject]))
		{
		Class c=[[NSBundle bundleWithPath:pluginPath] principalClass];
#if 1
		NSLog(@"Plugin loaded %@ - principal class %@", pluginPath, NSStringFromClass(c));
#endif
		}
	// should somehow execute script within runloop!
	NS_DURING	// set up exception handler!
		{
		NSString *sourcePath;
		NSString *source;
		NSScanner *sc;
		HNSCocoaScript *s;
		id r;
		int ir;
		sourcePath=[[NSBundle mainBundle] pathForResource:@"CocoaScript" ofType:@"code"];
		if(sourcePath == nil)
			[NSException raise:@"Runtime Error" format:@"can't find executable"];
#if 1
		NSLog(@"sourcePath=%@", sourcePath);
#endif
		source=[NSString stringWithContentsOfFile:sourcePath];
		if(source == nil)
			[NSException raise:@"Runtime Error" format:@"can't load executable (%@)", sourcePath];
		sc=[NSScanner scannerWithString:source];
#if 1
		NSLog(@"scanner=%@", [sc string]);
#endif
		s=[[HNSCocoaScript alloc] initFromScanner:sc];
		if(s == nil)
			[NSException raise:@"Runtime Error" format:@"can't interpret executable (%@)", sourcePath];
#if 0
		// somehow tie loaded scripts to classes - then, no direct invocation required!
		// get Nib to load initially from Info.plist
  		[NSBundle loadNibNamed:@"myMain" owner:NSApp];
  		[NSApp run];
		ir=0;
#else
		r=[s evaluate];
#if 1
		NSLog(@"result: %@", r);
#endif
		ir=[r intValue];
#endif
		[pool release];
		return ir;
		}
	NS_HANDLER
		{ // exception, i.e. syntax error or alike
		NSRunAlertPanel([localException name], @"%@", @"OK", nil, nil, localException);
		[pool release];
		return 1;	// error
		}
	NS_ENDHANDLER
	return 127;	// internal error
}
